(function ($) {
  "use strict";

  var HorizontalSearchHandler = function ($scope, $) {
    var search_form = $scope.find('.felan-search-horizontal');
    var filter_search = search_form.find('#search-horizontal_filter_search');

    filter_search.autocomplete({
      minLength: 0,
      delay: 500,
      source: function (request, response) {
        var spinner = search_form.find('.ui-autocomplete-spinner');
        spinner.show();

        $.ajax({
          url: theme_vars.ajax_url,
          dataType: "json",
          data: {
            action: 'felan_ajax_ui',
            q: request.term || '',
            taxonomy: filter_search.attr('data-taxonomy'),
          },
          success: function (data) {
            if (Array.isArray(data)) {
              response(data);
            } else if (data && Array.isArray(data.results)) {
              response(data.results);
            } else {
              response([]);
            }
          },
          complete: function () {
            spinner.hide();
          }
        });
      },
      autoFocus: false
    });

    filter_search.on("focus", function () {
      if ($(this).val().length >= 0) {
        $(this).autocomplete("search", $(this).val());
      }
    });

    search_form.find(".felan-clear-top-filter").on("click", function () {
      filter_search.val("");
      search_form.find(".input-search-location").val("");

      var list_select = search_form.find(".felan-select2");
      list_select.val("").trigger("change").select2("destroy").select2();
      list_select.each(function () {
        var $this = $(this),
          option = $this.find('option');

        var options = {
          minimumResultsForSearch: -1
        };

        if (theme_vars.enable_search_box_dropdown == 1 && option.length > theme_vars.limit_search_box) {
          options.minimumResultsForSearch = 0;
        }

        $this.select2(options);
      });

      var updateSelect2Level = function ($options) {
        $options.each(function () {
          var option_val = $(this).val();
          var level = $(this).attr('data-level');
          $('.select2-results li[id$="' + option_val + '"]').attr('data-level', level);
        });
      };

      $('.select2.select2-container').off('click.updateLevel').on('click.updateLevel', function () {
        updateSelect2Level($(this).prev().find('option'));
      });
      $('.felan-form-location .icon-arrow i').off('click.updateLevel').on('click.updateLevel', function () {
        updateSelect2Level($(this).closest('.felan-form-location').find('select.felan-select2 option'));
      });

      $("body").off("mousedown.felanFormLocation").on("mousedown.felanFormLocation", ".felan-form-location .icon-arrow i", function (e) {
        e.preventDefault();
        var form = $(".archive-layout .felan-form-location");
        var field_select = form.find('select.felan-select2');
        var select2_container = form.find('.select2.select2-container');
        if (select2_container.hasClass('select2-container--open')) {
          field_select.select2("close");
        } else {
          field_select.val(null).trigger("change");
          field_select.select2("open");
        }
      });
    });
  };

  $(window).on("elementor/frontend/init", function () {
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/felan-search-horizontal.default",
      HorizontalSearchHandler
    );
  });
})(jQuery);
